import {
    GameMode,
    ItemStack,
    world
} from "@minecraft/server"



world.afterEvents.playerSpawn.subscribe(event => {
    const initialSpawn = event.initialSpawn
    const player = event.player
    if (initialSpawn) {
        player.dimension.setBlockType(player.location, "test:test")
        player.setGameMode(GameMode.survival)
    }
})

world.afterEvents.entityHitBlock.subscribe(event => {
    event.damagingEntity.startTime = new Date().getTime()
})

world.afterEvents.playerBreakBlock.subscribe(event => {
    const player = event.player
    player.sendMessage(`Break time: ${(new Date().getTime() - player.startTime) / 1000} seconds`)
})